-- Migration to create the friends table
CREATE TABLE friends (
  id INT PRIMARY KEY AUTO_INCREMENT,
  user_one_id INT NOT NULL, -- Smaller user ID
  user_two_id INT NOT NULL, -- Larger user ID
  status ENUM('pending', 'accepted') NOT NULL,
  -- user_id of the one who sent the request or performed the last action.
  -- For 'pending' status, if action_user_id is user_one_id, then user_two_id is the recipient.
  -- If action_user_id is user_two_id, then user_one_id is the recipient.
  action_user_id INT NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (user_one_id) REFERENCES users(id) ON DELETE CASCADE,
  FOREIGN KEY (user_two_id) REFERENCES users(id) ON DELETE CASCADE,
  FOREIGN KEY (action_user_id) REFERENCES users(id) ON DELETE CASCADE,
  CONSTRAINT uq_friendship UNIQUE (user_one_id, user_two_id),
  CONSTRAINT ck_user_order CHECK (user_one_id < user_two_id) -- Ensures IDs are always stored in specific order
);

-- Index for performance
CREATE INDEX idx_friends_user_one ON friends(user_one_id, status);
CREATE INDEX idx_friends_user_two ON friends(user_two_id, status);
CREATE INDEX idx_friends_action_user ON friends(action_user_id, status);
